//=============================================================================
// WorkBenchMenuMain
//=============================================================================

class WorkBenchMenuCustomRifle expands MenuUIWindow;



#exec TEXTURE IMPORT NAME="WBMWhite" FILE="Textures\WBMWhite.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="WBMRed" FILE="Textures\WBMRed.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="WBMOrange" FILE="Textures\WBMOrange.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="WBMGold" FILE="Textures\WBMYellow.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="WBMGreen" FILE="Textures\WBMGreen.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="WBMBlue" FILE="Textures\WBMBlue.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="WBMPurple" FILE="Textures\WBMPurple.pcx" GROUP=Skins FLAGS=2


//Universals
var DeusExPlayer Player;
var PartsBag Bench;
var MSMassEffectMutator Mutator;

//Window Specifics
var MenuUIActionButtonWindow exitButton;
var localized string exitButtonText;

var NextPartButton UpButton[5];
var PrevPartButton DownButton[5];

var CraftingStock CurStock;
var CraftingBody CurBody;
var CraftingFeed CurFeed;
var CraftingPin CurPin;
var CraftingBarrel CurBarrel;

var Window Overlay1, Overlay2, PinOverlay;
var Window StockDisplay, BodyDisplay, FeedDisplay, PinDisplay, BarrelDisplay;

var ModifiedPersonaTextWindow Durabilities[5];

var ModifiedPersonaTextWindow  StatDisplay, NamePointer, ColorPointer;
var MenuUIEditWindow CustomNameField;

var Window ColorDisplay;
var ColorButtonForward NextColor;
var ColorButtonBackward PrevColor;
var int CurColor; //White, Yellow, Green, Blue, Purple, Red, Orange.
var String ColorPickerValues[7]; //these might be slightly off, but it works.

var PersonaActionButtonWindow CreateButton;

var Window Last;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window... it's way down there...
// In the meantime, here's a lot of precautionary vomit!
// ----------------------------------------------------------------------


function bool CanPushScreen(Class <DeusExBaseWindow> newScreen)
{
 return false;
}

function bool CanStack()
{
 return false;
}

event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
 return false;
}

event bool RawKeyPressed(EInputKey key, EInputState iState, bool bRepeat)
{
 return false;
}

event InitWindow()
{
 local int i, j;

	Super.InitWindow();
        SetTitle("Custom Rifle Creation");
        exitButton = winButtonBar.AddButton(exitButtonText, HALIGN_Left);
	
	CreateOverlays();
	CreateButtons();
        CreateDurabilities();
	CreateTextDisplay();

	CustomNameField = CreateMenuEditWindow(352, 272, 132, 24, winClient);
	CustomNameField.SetText("Custom Rifle X");
}

function CreateTextDisplay()
{
 StatDisplay = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 StatDisplay.SetPos(16, 268);
 StatDisplay.SetSize(240, 96);
 StatDisplay.SetFont(Font'FontMenuHeaders');

 NamePointer = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 NamePointer.SetPos(296, 284);
 NamePointer.SetSize(72, 40);
 NamePointer.SetFont(Font'FontMenuHeaders');
 NamePointer.SetText("|p4NAME IT! >");
 
 ColorPointer = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 ColorPointer.SetPos(327, 332);
 ColorPointer.SetSize(96, 20);
 ColorPointer.SetFont(Font'FontMenuHeaders');
 ColorPointer.SetText("|c448affNAME COLOR:");

}

function CreateDurabilities()
{
 Durabilities[0] = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Durabilities[0].SetPos(67, 107);
 Durabilities[0].SetSize(96, 20);
 Durabilities[0].SetFont(Font'FontMenuHeaders');
 Durabilities[1] = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Durabilities[1].SetPos(203, 103);
 Durabilities[1].SetSize(96, 20);
 Durabilities[1].SetFont(Font'FontMenuHeaders');
 Durabilities[2] = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Durabilities[2].SetPos(227, 139);
 Durabilities[2].SetSize(96, 20);
 Durabilities[2].SetFont(Font'FontMenuHeaders');
 Durabilities[3] = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Durabilities[3].SetPos(172, 91);
 Durabilities[3].SetSize(96, 20);
 Durabilities[3].SetFont(Font'FontMenuHeaders');
 Durabilities[4] = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Durabilities[4].SetPos(375, 84);
 Durabilities[4].SetSize(96, 20);
 Durabilities[4].SetFont(Font'FontMenuHeaders');
}

function CreateButtons()
{
 	UpButton[0] = NextPartButton(NewChild(Class'NextPartButton'));
	UpButton[0].SetPos(67, 62);
 	UpButton[1] = NextPartButton(NewChild(Class'NextPartButton'));
	UpButton[1].SetPos(203, 53);
 	UpButton[2] = NextPartButton(NewChild(Class'NextPartButton'));
	UpButton[2].SetPos(227, 83);
 	UpButton[3] = NextPartButton(NewChild(Class'NextPartButton'));
	UpButton[3].SetPos(172, 60);
 	UpButton[4] = NextPartButton(NewChild(Class'NextPartButton'));
	UpButton[4].SetPos(375, 26);
	
 	DownButton[0] = PrevPartButton(NewChild(Class'PrevPartButton'));
	DownButton[0].SetPos(67, 148);
 	DownButton[1] = PrevPartButton(NewChild(Class'PrevPartButton'));
	DownButton[1].SetPos(203, 153);
 	DownButton[2] = PrevPartButton(NewChild(Class'PrevPartButton'));
	DownButton[2].SetPos(227, 195);
 	DownButton[3] = PrevPartButton(NewChild(Class'PrevPartButton'));
	DownButton[3].SetPos(172, 122);
 	DownButton[4] = PrevPartButton(NewChild(Class'PrevPartButton'));
	DownButton[4].SetPos(375, 142);
	
 	NextColor = ColorButtonForward(NewChild(Class'ColorButtonForward'));
	NextColor.SetPos(407, 352);
 	PrevColor = ColorButtonBackward(NewChild(Class'ColorButtonBackward'));
	PrevColor.SetPos(343, 352);
	
	CreateButton = PersonaActionButtonWindow(NewChild(Class'PersonaActionButtonWindow'));
	CreateButton.SetPos(448, 368);
	CreateButton.SetButtonText("CREATE!");
	CreateButton.SetSensitivity(False);
}

function CreateOverlays()
{
	Overlay1 = NewChild(Class'Window');
	SetupOverlay(Overlay1, 0, 0, 256, 256);
	Overlay1.SetBackground(Texture'WorkbenchRifleOverlay1');

	Overlay2 = NewChild(Class'Window');
	SetupOverlay(Overlay2, 256, 0, 256, 256);	
	Overlay2.SetBackground(Texture'WorkbenchRifleOverlay2');
	
	StockDisplay = NewChild(Class'Window');
	SetupOverlay(StockDisplay, 0, 0, 256, 256);
		
	FeedDisplay = NewChild(Class'Window');
	SetupOverlay(FeedDisplay, 201, 107, 128, 128);

	BarrelDisplay = NewChild(Class'Window');
	SetupOverlay(BarrelDisplay, 256, 0, 256, 256);

	BodyDisplay = NewChild(Class'Window');
	SetupOverlay(BodyDisplay, 117, 75, 256, 128);

	//Reinforce the pin overlay, otherwise it's invisible
	
	PinOverlay = NewChild(Class'Window');
	SetupOverlay(PinOverlay, 0, 0, 256, 140);
	PinOverlay.SetBackground(Texture'WorkBenchRiflePinOverlay');
	
	PinDisplay = NewChild(Class'Window');
	SetupOverlay(PinDisplay, 0, 0, 256, 128);

	ColorDisplay = NewChild(Class'Window');
	SetupOverlay(ColorDisplay, 375, 352, 32, 32);
	ColorDisplay.SetBackground(Texture'WBMWhite');	
}

function SetupOverlay(Window Win, int PosX, int PosY, int WidthX, int HeightY)
{
	win.SetBackgroundStyle(DSTY_Masked);
	win.SetPos(PosX, PosY);
	win.SetSize(WidthX, HeightY);
}

function UpdateIcons()
{
 if (CurStock != None && !CurStock.bDeleteMe) StockDisplay.SetBackground(CurStock.BenchIcon);
 if (CurBody != None && !CurBody.bDeleteMe) BodyDisplay.SetBackground(CurBody.BenchIcon);
 if (CurFeed != None && !CurFeed.bDeleteMe) FeedDisplay.SetBackground(CurFeed.BenchIcon);
 if (CurPin != None && !CurPin.bDeleteMe) PinDisplay.SetBackground(CurPin.BenchIcon);
 if (CurBarrel != None && !CurBarrel.bDeleteMe) BarrelDisplay.SetBackground(CurBarrel.BenchIcon);
 
 UpdateStats();
 UpdateColor();
}

function UpdateColor()
{
 if (CurColor < 0) CurColor = 6;
 if (CurColor > 6) CurColor = 0;
 
 if (CurColor == 0) ColorDisplay.SetBackground(Texture'WBMWhite');
 if (CurColor == 1) ColorDisplay.SetBackground(Texture'WBMGold');
 if (CurColor == 2) ColorDisplay.SetBackground(Texture'WBMGreen');
 if (CurColor == 3) ColorDisplay.SetBackground(Texture'WBMBlue');
 if (CurColor == 4) ColorDisplay.SetBackground(Texture'WBMPurple');
 if (CurColor == 5) ColorDisplay.SetBackground(Texture'WBMRed');
 if (CurColor == 6) ColorDisplay.SetBackground(Texture'WBMOrange');
}

function UpdateStats()
{
 
 if (CurStock != None && CurBody != None && CurFeed != None && CurPin != None && CurBarrel != None) CreateButton.SetSensitivity(True);
 if (CurStock == None || CurBody == None || CurFeed == None || CurPin == None || CurBarrel == None) CreateButton.SetSensitivity(False);
 if (CurStock.bDeleteMe || CurBody.bDeleteMe || CurFeed.bDeleteMe || CurPin.bDeleteMe || CurBarrel.bDeleteMe) CreateButton.SetSensitivity(False);

 StatDisplay.SetText(BuildWeaponStats());
 
 if (CurStock != None && !CurStock.bDeleteMe) Durabilities[0].SetText(CurStock.CurDurability$"/"$CurStock.Durability);
 if (CurBody != None && !CurBody.bDeleteMe) Durabilities[1].SetText(CurBody.CurDurability$"/"$CurBody.Durability);
 if (CurFeed != None && !CurFeed.bDeleteMe) Durabilities[2].SetText(CurFeed.CurDurability$"/"$CurFeed.Durability);
 if (CurPin != None && !CurPin.bDeleteMe) Durabilities[3].SetText(CurPin.CurDurability$"/"$CurPin.Durability);
 if (CurBarrel != None && !CurBarrel.bDeleteMe) Durabilities[4].SetText(CurBarrel.CurDurability$"/"$CurBarrel.Durability);

 if (CurStock == None || CurStock.bDeleteMe) Durabilities[0].SetText("");
 if (CurBody == None || CurStock.bDeleteMe) Durabilities[1].SetText("");
 if (CurFeed == None || CurStock.bDeleteMe) Durabilities[2].SetText("");
 if (CurPin == None || CurStock.bDeleteMe) Durabilities[3].SetText("");
 if (CurBarrel == None || CurStock.bDeleteMe) Durabilities[4].SetText("");
}

simulated function String FormatFloatString(float value, float precision)
{
	local string str;

	if (precision == 0.0)
		return "ERR";

	// build integer part
	str = String(Int(value));

	// build decimal part
	if (precision < 1.0)
	{
		value -= Int(value);
		str = str $ "." $ String(Int((0.5 * precision) + value * (1.0 / precision)));
	}

	return str;
}

function CreateWeapon()
{
 local CustomRifle C;
 
 local bool bHasBurst, bHasAuto;
 local int Recoil, Weight, Accuracy, Capacity, Caliber;
 local float Reload, Rate;
 
 if (CurStock == None || CurBody == None || CurFeed == None || CurPin == None || CurBarrel == None) return;
 if (CurStock.bDeleteMe || CurBody.bDeleteMe || CurFeed.bDeleteMe || CurPin.bDeleteMe || CurBarrel.bDeleteMe) return;
 
 bHasBurst = CurPin.bHasBurst;
 bHasAuto = CurPin.bHasAuto;
 
 Recoil = CurBarrel.RecoilMod + CurStock.RecoilMod;
 Weight = CurBody.WeightMod + CurFeed.WeightMod + CurStock.WeightMod;
 Accuracy = CurBarrel.AccuracyMod;
 Capacity = CurFeed.CapacityMod;
 Caliber = CurBarrel.CaliberType;
 Reload = CurFeed.ReloadMod + CurPin.ReloadMod;
 Rate = CurPin.RateMod;
 
 C = Bench.Spawn(class'CustomRifle',,,Bench.Location + vect(0,0,30));
 
 C.bHasBurst = bHasBurst;
 C.bHasAuto = bHasAuto;
 C.RecoilMod = Recoil;
 C.WeightMod = Weight;
 C.AccMod = Accuracy;
 C.ClipMod = Capacity;
 C.CaliberType = Caliber;
 C.ReloadMod = Reload;
 C.RateMod = Rate;
 
 C.SilencedFireSound = CurBarrel.SilencedFireSound;
 C.CustomFireSound = CurBarrel.FireSound;
 C.Reload1Sound = CurFeed.ReloadSound;
 C.Reload2Sound = CurFeed.ReloadEndSound;
 C.AfterFireSound = CurPin.AfterFireSound;
 C.SelectSound = CurStock.SelectSound;
 
 C.SilenFire = String(CurBarrel.SilencedFireSound);
 C.CusFire = String(CurBarrel.FireSound);
 C.Reload1 = String(CurFeed.ReloadSound);
 C.Reload2 = String(CurFeed.ReloadEndSound);
 C.AftFire = String(CurPin.AfterFireSound);
 C.CusSelect = String(CurStock.SelectSound);

 //C.SilenFire = ;
 
 C.CurPinDurability = CurPin.CurDurability;
 C.CurBarrelDurability = CurBarrel.CurDurability;
 C.CurFeedDurability = CurFeed.CurDurability;
 C.CurStockDurability = CurStock.CurDurability;
 C.CurBodyDurability = CurBody.CurDurability;

 C.PinDurability = CurPin.Durability;
 C.BarrelDurability = CurBarrel.Durability;
 C.FeedDurability = CurFeed.Durability;
 C.StockDurability = CurStock.Durability;
 C.BodyDurability = CurBody.Durability;
 
 C.BodyName = String(CurBody.Class);
 C.StockName = String(CurStock.Class);
 C.PinName = String(CurPin.Class);
 C.BarrelName = String(CurBarrel.Class);
 C.FeedName = String(CurFeed.Class);

 C.Multi0 = String(RifleStock(CurStock).Default.Multi0);
 C.Multi1 = String(RifleBody(CurBody).Default.Multi1);
 C.Multi4 = String(RifleFeed(CurFeed).Default.Multi4);
 C.Multi5 = String(RifleBarrel(CurBarrel).Default.Multi5);
 C.Multi6 = String(RifleBarrel(CurBarrel).Default.Multi6);
 C.PickupMesh = String(RifleFeed(CurFeed).Default.PickupMesh);
 C.ThirdMesh = String(RifleFeed(CurFeed).Default.ThirdMesh);
 //C.FirstMesh = String(RifleFeed(CurFeed).Default.FirstMesh);

 C.bHasStock = True;
 C.bHasFeed = True;
 
 C.CustomName = CustomNameField.GetText();
 C.CustomColor = ColorPickerValues[CurColor];
 
 C.UpdateStats();
 
 C.SwitchFiringModes();
 if (bHasBurst) C.SwitchFiringModes();
 if (bHasAuto) C.SwitchFiringModes();
 
 /*CurBarrel.Destroy();
 CurPin.Destroy();
 CurFeed.Destroy();
 CurBody.Destroy();
 CurStock.Destroy();*/
 
 //Don't Destroy, parts are now stackable.
 
 CurBarrel.UseOnce();
 CurPin.UseOnce();
 CurFeed.UseOnce();
 CurBody.UseOnce();
 CurStock.UseOnce();
 
 CreateButton.SetSensitivity(False);
 
 CustomNameField.SetText("Custom Rifle X");
 CurColor = 0;
 
 Bench.PlaySound(Sound'BreakdownPart');
 
 UpdateIcons();
 ClearIcons();
}

function ClearIcons()
{
 if (CurStock == None || CurStock.bDeleteMe) StockDisplay.SetBackground(None);
 if (CurBody == None || CurBody.bDeleteMe) BodyDisplay.SetBackground(None);
 if (CurFeed == None || CurFeed.bDeleteMe) FeedDisplay.SetBackground(None);
 if (CurPin == None || CurPin.bDeleteMe) PinDisplay.SetBackground(None);
 if (CurBarrel == None || CurBarrel.bDeleteMe) BarrelDisplay.SetBackground(None);
}

function String BuildWeaponStats()
{
 local string S, Modes, Caliber, RateS, ReloadS;
 local int Recoil, Weight, Accuracy, Capacity;
 local float Reload, Rate;
 
 if (CurStock == None && CurBody == None && CurFeed == None && CurPin == None && CurBarrel == None) return "";
 if (CurStock.bDeleteMe && CurBody.bDeleteMe && CurFeed.bDeleteMe && CurPin.bDeleteMe && CurBarrel.bDeleteMe) return "";
 
 Weight = 25;
 Accuracy = 75;
 Reload = 3;
 Rate = 0.1;
 Recoil = 5;
 
 if (CurBarrel != None) 
 {
  Caliber = "Caliber: "$FormatFloatString(  float(CurBarrel.CaliberType) / 100, 0.01  )$"mm";
  Accuracy += CurBarrel.AccuracyMod * 5;
  Recoil += CurBarrel.RecoilMod;
 }
 if (CurBody != None)
 {
  Weight += CurBody.WeightMod;
 }
 if (CurFeed != None)
 {
  Weight += CurFeed.WeightMod;
  Capacity = CurFeed.CapacityMod;
  Reload += CurFeed.ReloadMod;
 }
 if (CurPin != None)
 {
  Reload += CurPin.ReloadMod;
  Rate += CurPin.RateMod;
  
  Modes = "Modes: Semi ";
  if (CurPin.bHasBurst) Modes = Modes@"Burst";
  if (CurPin.bHasAuto) Modes = Modes@"Auto ";
 }
 if (CurStock != None)
 {
  Recoil += CurStock.RecoilMod;
  Weight += CurStock.WeightMod;
 }
 
 ReloadS = FormatFloatString(Reload, 0.1);
 RateS = FormatFloatString(Rate, 0.01);
 
 S = Modes@Caliber$CR()$"Refire: "$RateS@"Reload: "$ReloadS$CR()$"Recoil: "$Recoil@"Weight: "$Weight$CR()$"Accuracy: "$Accuracy$"%"@"Capacity: "$Capacity@"Rounds";
 
 return S;
}

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;
	local name TempName;

	bHandled = True;

	Super.ButtonActivated(buttonPressed);

	switch(buttonPressed)
	{
		case exitButton:
			//Ralph.ChargeTheGates(TempName);
			// Do stuff

			Last.Show(True);

			root.PopWindow();
			bHandled = True;
			break;

		case UpButton[0]:
			NextStock();
			bHandled = True;
			break;
		case UpButton[1]:
			NextBody();
			bHandled = True;
			break;
		case UpButton[2]:
			NextFeed();
			bHandled = True;
			break;
		case UpButton[3]:
			NextPin();
			bHandled = True;
			break;
		case UpButton[4]:
			NextBarrel();
			bHandled = True;
			break;

		case DownButton[0]:
			PrevStock();
			bHandled = True;
			break;
		case DownButton[1]:
			PrevBody();
			bHandled = True;
			break;
		case DownButton[2]:
			PrevFeed();
			bHandled = True;
			break;
		case DownButton[3]:
			PrevPin();
			bHandled = True;
			break;
		case DownButton[4]:
			PrevBarrel();
			bHandled = True;
			break;

		case NextColor:
			CurColor++;
			UpdateIcons();
			bHandled = True;
			break;
		case PrevColor:
			CurColor--;
			UpdateIcons();
			bHandled = True;
			break;

		case CreateButton:
			CreateWeapon();
			bHandled = True;
			break;

		default:
			bHandled = False;
			break;
	}

	/*if (ButtonPressed != exitButton)
	{
		UpdateInfo();
	}*/

	return bHandled;
}

//==================================================
//++++++++++++++++++++++++++++++++++++++++++++++++++
//NEXT PART FUNCTIONS BEGIN
//++++++++++++++++++++++++++++++++++++++++++++++++++
//==================================================

function NextStock()
{
 local RifleStock P, Pick, First, Last;
 local bool bNext;
 
 forEach Player.AllActors(class'RifleStock', P)
 {
  if (P.Owner == Player)
  {
   if (First == None) First = P;
   Last = P;
   
   if (bNext)
   {
    Pick = P;
    break;
   }
   if (CurStock == None)
   {
    Pick = First;
    break;
   }
   
   if (P == CurStock) bNext = True;
  }
 }
 
 if (Pick == None)
 {
  Pick = First;
 }
 
 CurStock = Pick;
 UpdateIcons();
}

function NextBody()
{
 local RifleBody P, Pick, First, Last;
 local bool bNext;
 
 forEach Player.AllActors(class'RifleBody', P)
 {
  if (P.Owner == Player)
  {
   if (First == None) First = P;
   Last = P;
   
   if (bNext)
   {
    Pick = P;
    break;
   }
   if (CurBody == None)
   {
    Pick = First;
    break;
   }
   
   if (P == CurBody) bNext = True;
  }
 }
 
 if (Pick == None)
 {
  Pick = First;
 }
 
 CurBody = Pick;
 UpdateIcons();
}

function NextFeed()
{
 local RifleFeed P, Pick, First, Last;
 local bool bNext;
 
 forEach Player.AllActors(class'RifleFeed', P)
 {
  if (P.Owner == Player)
  {
   if (First == None) First = P;
   Last = P;
   
   if (bNext)
   {
    Pick = P;
    break;
   }
   if (CurFeed == None)
   {
    Pick = First;
    break;
   }
   
   if (P == CurFeed) bNext = True;
  }
 }
 
 if (Pick == None)
 {
  Pick = First;
 }
 
 CurFeed = Pick;
 UpdateIcons();
}

function NextPin()
{
 local RiflePin P, Pick, First, Last;
 local bool bNext;
 
 forEach Player.AllActors(class'RiflePin', P)
 {
  if (P.Owner == Player)
  {
   if (First == None) First = P;
   Last = P;
   
   if (bNext)
   {
    Pick = P;
    break;
   }
   if (CurPin == None)
   {
    Pick = First;
    break;
   }
   
   if (P == CurPin) bNext = True;
  }
 }
 
 if (Pick == None)
 {
  Pick = First;
 }
 
 CurPin = Pick;
 UpdateIcons();
}

function NextBarrel()
{
 local RifleBarrel P, Pick, First, Last;
 local bool bNext;
 
 forEach Player.AllActors(class'RifleBarrel', P)
 {
  if (P.Owner == Player)
  {
   if (First == None) First = P;
   Last = P;
   
   if (bNext)
   {
    Pick = P;
    break;
   }
   if (CurBarrel == None)
   {
    Pick = First;
    break;
   }
   
   if (P == CurBarrel) bNext = True;
  }
 }
 
 if (Pick == None)
 {
  Pick = First;
 }
 
 CurBarrel = Pick;
 UpdateIcons();
}

//==================================================
//++++++++++++++++++++++++++++++++++++++++++++++++++
//NEXT PART FUNCTIONS END
//++++++++++++++++++++++++++++++++++++++++++++++++++
//==================================================

//==================================================
//--------------------------------------------------
//PREV PART FUNCTIONS BEGIN
//--------------------------------------------------
//==================================================

function PrevStock()
{
 local RifleStock P, Pick, First, Last;
 
 forEach Player.AllActors(class'RifleStock', P)
 {
  if (P.Owner == Player)
  {
   if (First == None) First = P;
   
   if (P == CurStock && P != First)
   {
    Pick = Last;
    break;
   }
   
   Last = P;
  }
 }
 
 if (CurStock == None || Pick == None)
 {
  Pick = Last;
 }

 CurStock = Pick;
 UpdateIcons();
}

function PrevBody()
{
 local RifleBody P, Pick, First, Last;
 
 forEach Player.AllActors(class'RifleBody', P)
 {
  if (P.Owner == Player)
  {
   if (First == None) First = P;
   
   if (P == CurBody && P != First)
   {
    Pick = Last;
    break;
   }
   
   Last = P;
  }
 }
 
 if (CurBody == None || Pick == None)
 {
  Pick = Last;
 }

 CurBody = Pick;
 UpdateIcons();
}

function PrevFeed()
{
 local RifleFeed P, Pick, First, Last;
 
 forEach Player.AllActors(class'RifleFeed', P)
 {
  if (P.Owner == Player)
  {
   if (First == None) First = P;
   
   if (P == CurFeed && P != First)
   {
    Pick = Last;
    break;
   }
   
   Last = P;
  }
 }
 
 if (CurFeed == None || Pick == None)
 {
  Pick = Last;
 }

 CurFeed = Pick;
 UpdateIcons();
}

function PrevPin()
{
 local RiflePin P, Pick, First, Last;
 
 forEach Player.AllActors(class'RiflePin', P)
 {
  if (P.Owner == Player)
  {
   if (First == None) First = P;
   
   if (P == CurPin && P != First)
   {
    Pick = Last;
    break;
   }
   
   Last = P;
  }
 }
 
 if (CurPin == None || Pick == None)
 {
  Pick = Last;
 }

 CurPin = Pick;
 UpdateIcons();
}

function PrevBarrel()
{
 local RifleBarrel P, Pick, First, Last;
 
 forEach Player.AllActors(class'RifleBarrel', P)
 {
  if (P.Owner == Player)
  {
   if (First == None) First = P;
   
   if (P == CurBarrel && P != First)
   {
    Pick = Last;
    break;
   }
   
   Last = P;
  }
 }
 
 if (CurBarrel == None || Pick == None)
 {
  Pick = Last;
 }

 CurBarrel = Pick;
 UpdateIcons();
}
//==================================================
//--------------------------------------------------
//PREV PART FUNCTIONS END
//--------------------------------------------------
//==================================================

function CraftRifle()
{
}

defaultproperties
{
     ColorPickerValues(0)="|cffffff"
     ColorPickerValues(1)="|ce5e500"
     ColorPickerValues(2)="|c20a748"
     ColorPickerValues(3)="|c0099db"
     ColorPickerValues(4)="|c9a459b"
     ColorPickerValues(5)="|cdf1b22"
     ColorPickerValues(6)="|cff7825"

     Title="Custom Rifle Creation"
     exitButtonText="Done"
     ClientWidth=512
     ClientHeight=384

     clientTextures(0)=Texture'WorkBenchRifleBG1'
     clientTextures(1)=Texture'WorkBenchRifleBG2'
     clientTextures(2)=Texture'WorkBenchRifleBG3'
     clientTextures(3)=Texture'WorkBenchRifleBG4'

     bActionButtonBarActive=True
     bUsesHelpWindow=False
     ScreenType=ST_Persona
     TextureRows=2
     TextureCols=2
     exitButtonText="Cancel"

}
